// postfix.java
// oblicza warto wyraenia przyrostkowego
// uruchomienie programu: C>java PostfixApp
import java.io.*;              // operacje wejcia-wyjcia
////////////////////////////////////////////////////////////////
class StackX
   {
   private int maxSize;
   private int[] stackArray;
   private int top;
//--------------------------------------------------------------
   public StackX(int s)       // konstruktor
      {
      maxSize = s;
      stackArray = new int[maxSize];
      top = -1;
      }
//--------------------------------------------------------------
   public void push(int j)  // odkada liczb na stosie
      { stackArray[++top] = j; }
//--------------------------------------------------------------
   public int pop()         // zdejmuje liczb ze stosu
      { return stackArray[top--]; }
//--------------------------------------------------------------
   public int peek()        // podglda liczb na szczycie stosu
      { return stackArray[top]; }
//--------------------------------------------------------------
   public boolean isEmpty()  // zwraca true, jeeli stos pusty
      { return (top == -1); }
//--------------------------------------------------------------
   public boolean isFull()  // zwraca true, jeeli stos peny
      { return (top == maxSize-1); }
//-------------------------------------------------------------
   public int size()         // zwraca ilo elementw na stosie
      { return top+1; }
//--------------------------------------------------------------
   public int peekN(int n)  // zwraca element o indeksie n
      { return stackArray[n]; }
//--------------------------------------------------------------
   public void displayStack(String s)
      {
      System.out.print(s);
      System.out.print("stos (dno-->szczyt): ");
      for(int j=0; j<size(); j++)
         {
         System.out.print( peekN(j) );
         System.out.print(' ');
         }
      System.out.println("");
      }
//--------------------------------------------------------------
   }  // koniec klasy StackX
////////////////////////////////////////////////////////////////
class ParsePost
   {
   private StackX theStack;
   private String input;
//--------------------------------------------------------------
   public ParsePost(String s)
      { input = s; }
//--------------------------------------------------------------
   public int doParse()
      {
      theStack = new StackX(20);             // tworzymy nowy stos
      char ch;
      int j;
      int num1, num2, interAns;

      for(j=0; j<input.length(); j++)       // dla kadego znaku...
         {
         ch = input.charAt(j);              // ...pobieramy go z wejcia
         theStack.displayStack(""+ch+" ");  // *diagnostyka*
         if(ch >= '0' && ch <= '9')         // jeeli to liczba...
            theStack.push( (int)(ch-'0') ); // ...odkadamy j na stosie
         else                               // jeeli to operator...
            {
            num2 = theStack.pop();          // ...zdejmujemy argumenty...
            num1 = theStack.pop();
            switch(ch)                      // ...i wykonujemy dziaanie
               {
               case '+':
                  interAns = num1 + num2;
                  break;
               case '-':
                  interAns = num1 - num2;
                  break;
               case '*':
                  interAns = num1 * num2;
                  break;
               case '/':
                  interAns = num1 / num2;
                  break;
               default:
                  interAns = 0;
               }  // koniec switch
            theStack.push(interAns);        // odkadamy na stosie wynik dziaania
            }  // koniec else
         }  // koniec for
      interAns = theStack.pop();            // pobieramy wynik kocowy
      return interAns;
      }  // koniec doParse()
   }  // koniec klasy ParsePost
////////////////////////////////////////////////////////////////
class PostfixApp
   {
   public static void main(String[] args) throws IOException
      {
      String input;
      int output;

      while(true)
         {
         System.out.print("Wprowad wyraenie przyrostkowe:  ");
         System.out.flush();
         input = getString();         // wczytujemy napis z klawiatury
         if( input.equals("") )       // koniec, jeeli sam [Enter]
            break;
                                      // tworzymy obiekt obliczajcy
         ParsePost aParser = new ParsePost(input);
         output = aParser.doParse();  // obliczamy wynik
         System.out.println("Wynik wynosi " + output);
         }  // koniec while
      }  // koniec main()
//--------------------------------------------------------------
   public static String getString() throws IOException
      {
      InputStreamReader isr = new InputStreamReader(System.in);
      BufferedReader br = new BufferedReader(isr);
      String s = br.readLine();
      return s;
      }
//--------------------------------------------------------------
   }  // koniec klasy PostfixApp
////////////////////////////////////////////////////////////////
